# Input
# The ﬁrst line contains two integers n and p separated by a space: the monthly salary of a wizard in gold
# and the annual inﬂation rate (103 ≤ n ≤ 105 ; 0 ≤ p ≤ 100).
# Output
# Output the amount that the wizard will lose this year compared to the progressive salary payment system.
# Remember that a year in the magical kingdom consists of ten months. The answer is considered correct
# if the absolute or relative error does not exceed 10−4 .
# Example
# standard input
# 4346 1
# standard output
# 239.03

def lost_salary(n, p):
    months = 10
    monthly_increase = p / months / 100

    current_total = n * months
    progressive_total = sum(
        n * (1 + month * monthly_increase)
        for month in range(1, months + 1)
    )

    return progressive_total - current_total

if __name__ == "__main__":
    n, p = map(int, input().split())
    result = lost_salary(n, p)
    print(f"{result:.5f}")
