#include <iostream>
#include <vector>

typedef long long ll;

int main() {
  std::ios_base::sync_with_stdio(false);
  std::cin.tie(NULL);

  int launch_type_or_player_id;
  std::cin >> launch_type_or_player_id;

  if (launch_type_or_player_id == 0) {
    // first

    int n;
    std::cin >> n;
    std::vector<int> cards(n);
    ll total_sum = 0;

    for (int i = 0; i < n; ++i) {
      std::cin >> cards[i];
      total_sum += cards[i];
    }

    ll s_mod_n = total_sum % n;

    for (int i = 1; i <= n; ++i) {
      ll c_i = cards[i - 1];

      if ((2 * c_i + i) % n == s_mod_n) {
        std::cout << i << std::endl;
        return 0;
      }
    }

  } else {
    // second
    int p = launch_type_or_player_id;
    int visible_n;
    std::cin >> visible_n;

    ll n = visible_n + 1;

    ll visible_sum = 0;
    for (int i = 0; i < visible_n; ++i) {
      int card_val;
      std::cin >> card_val;
      visible_sum += card_val;
    }

    ll raw_guess = visible_sum - p;
    ll guess = (raw_guess % n + n) % n;

    if (guess == 0) {
      std::cout << n << std::endl;
    } else {
      std::cout << guess << std::endl;
    }
  }

  return 0;
}
