#include <iostream>
#include <vector>

void fast_io() {
  std::ios_base::sync_with_stdio(false);
  std::cin.tie(NULL);
}

int main() {
  fast_io();

  int n;
  std::cin >> n;

  std::vector<int> a(n);
  for (int i = 0; i < n; ++i) {
    std::cin >> a[i];
  }

  std::vector<int> result;

  for (int runner_num = n; runner_num >= 1; --runner_num) {
    int unexpected_wins = a[runner_num - 1];

    auto it = result.begin() + (result.size() - unexpected_wins);

    result.insert(it, runner_num);
  }

  for (int i = 0; i < n; ++i) {
    std::cout << result[i] << (i == n - 1 ? "" : " ");
  }
  std::cout << std::endl;

  return 0;
}
