#include <cmath>
#include <iomanip>
#include <iostream>

double calculate_distance(double x1, double y1, double x2, double y2) {
  double dx = x1 - x2;
  double dy = y1 - y2;
  return std::sqrt(dx * dx + dy * dy);
}

int main() {
  std::ios_base::sync_with_stdio(false);
  std::cin.tie(nullptr);

  double x1, y1, x2, y2, x3, y3, x4, y4;

  std::cin >> x1 >> y1 >> x2 >> y2 >> x3 >> y3 >> x4 >> y4;

  double side_length_1 = calculate_distance(x1, y1, x2, y2);
  double side_length_2 = calculate_distance(x2, y2, x3, y3);

  const double PI = acos(-1.0);

  double ellipse_area = (PI * side_length_1 * side_length_2) / 4.0;

  std::cout << std::fixed << std::setprecision(10) << ellipse_area << std::endl;

  return 0;
}
