#include <iostream>
#include <map>
#include <utility>

const long long MOD = 1000000007;

long long power(long long a, long long b, long long mod) {
    long long res = 1;
    a %= mod;
    while (b > 0) {
        if (b & 1) res = (res * a) % mod;
        a = (a * a) % mod;
        b >>= 1;
    }
    return res;
}

long long modinv(long long a) {
    return power(a, MOD - 2, MOD);
}

long long solve(int P, int M) {
    std::map<std::pair<int, int>, long long> dp;

    dp[std::make_pair(1, 0)] = 1;

    for (int half = P; half >= 0; half--) {
        for (int singles = 0; singles <= M; singles++) {
            if (half == 1 && singles == 0) {
                continue;
            }

            int full = P - half;
            if (full < 0) continue;

            long long total = 2LL * full + half + singles;
            if (total == 0) continue;

            long long inv_total = modinv(total);
            long long result = 1; 

            if (full > 0) {
                long long prob = (2LL * full % MOD * inv_total) % MOD;
                auto next_key = std::make_pair(half + 1, singles);
                if (dp.count(next_key)) {
                    long long next_val = dp[next_key];
                    result = (result + prob * next_val % MOD) % MOD;
                }
            }

            if (singles > 0) {
                long long prob = (1LL * singles % MOD * inv_total) % MOD;
                auto next_key = std::make_pair(half, singles - 1);
                if (dp.count(next_key)) {
                    long long next_val = dp[next_key];
                    result = (result + prob * next_val % MOD) % MOD;
                }
            }

            dp[std::make_pair(half, singles)] = result;
        }
    }

    return dp[std::make_pair(0, M)];
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int t;
    std::cin >> t;

    while (t--) {
        int p, m;
        std::cin >> p >> m;
        std::cout << solve(p, m) << "\n";
    }

    return 0;
}