#include <iostream>
#include <vector>
#include <limits>
#include <algorithm>

int main() {
    int n;
    if (!(std::cin >> n)) return 0;
    std::vector<long long> a(n);
    long long S = 0;
    for (int i = 0; i < n; ++i) {
        std::cin >> a[i];
        S += a[i];
    }

    long long min_area = LLONG_MAX;
    long long max_area = LLONG_MIN;

    int all = 1 << n;
    for (int mask = 1; mask <= all - 2; ++mask) {
        long long s = 0;
        for (int i = 0; i < n; ++i) {
            if (mask & (1 << i)) s += a[i];
        }
        long long area = s * (S - s);
        if (area < min_area) min_area = area;
        if (area > max_area) max_area = area;
    }

    std::cout << min_area << " " << max_area << "\n";
    return 0;
}