#include <iostream>
#include <vector>
#include <bitset>
using namespace std;

const int MOD = 999983;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n, s;
    cin >> n >> s;

    bitset<MOD> inV;
    vector<int> elements;
    elements.reserve(min(n, 100000)); // Эвристика: обычно V много меньше n

    for (int step = 0; step < n; step++) {
        s = (1LL * s * 618023 + 1) % MOD;

        int pairs = 0;
        // Быстрая проверка: перебираем только элементы V
        for (int i = 0; i < elements.size() && pairs < 2; i++) {
            int a = elements[i];
            int b = s - a;
            if (b >= 0 && b < MOD && inV[b] && a <= b) {
                pairs++;
                // Нас интересует только чётность, поэтому можно прерваться после 2 пар
                if (pairs >= 2) break;
            }
        }

        if (pairs % 2 == 0 && !inV[s]) {
            elements.push_back(s);
            inV.set(s);
        }
    }

    cout << elements.size() << endl;

    return 0;
}
