#include <iostream>
#include <string>
#include <vector>
using namespace std;

int main() {
    int t;
    cin >> t;

    while (t--) {
        string s;
        cin >> s;

        // Для каждой ноты храним множество возможных позиций (по модулю 7 + октава)
        // Но проще: храним min и max позицию для каждого остатка 0..6
        vector<int> min_pos(7, 1e9);
        vector<int> max_pos(7, -1e9);

        // Первая нота: можно выбрать любую позицию с нужной буквой
        int first = s[0] - 'A';
        min_pos[first] = 0;
        max_pos[first] = 0;

        bool possible = true;

        for (size_t i = 1; i < s.size(); i++) {
            int target = s[i] - 'A';
            int new_min = 1e9;
            int new_max = -1e9;

            // Проверяем все возможные переходы из предыдущих позиций
            for (int prev_r = 0; prev_r < 7; prev_r++) {
                if (min_pos[prev_r] > max_pos[prev_r]) continue; // недостижимый остаток

                for (int prev_pos = min_pos[prev_r]; prev_pos <= max_pos[prev_r]; prev_pos++) {
                    // Пробуем все возможные сдвиги от -3 до +3
                    for (int delta = -3; delta <= 3; delta++) {
                        int new_pos = prev_pos + delta;
                        if (new_pos % 7 == target || (new_pos % 7 + 7) % 7 == target) {
                            if (new_pos < new_min) new_min = new_pos;
                            if (new_pos > new_max) new_max = new_pos;
                        }
                    }
                }
            }

            if (new_min > new_max) {
                possible = false;
                break;
            }

            // Обновляем только для целевого остатка
            min_pos.assign(7, 1e9);
            max_pos.assign(7, -1e9);
            min_pos[target] = new_min;
            max_pos[target] = new_max;
        }

        cout << (possible ? "Yes" : "No") << '\n';
    }

    return 0;
}
