#include <cstdio>
#include <cstring>

const int MOD = 999983;
const int MAX_VAL = MOD;

int main() {
    int n, s;
    scanf("%d %d", &n, &s);
    bool visited[MAX_VAL];
    std::memset(visited, false, sizeof(visited));

    for (int step = 0; step < n; ++step) {
        s = (static_cast<long long>(s) * 618023LL + 1LL) % MOD;
        int pairCount = 0;
        for (int a = 0; a < MOD; ++a) {
            if (!visited[a]) continue;
            int b = s - a;
            if (b < 0 || b >= MOD) continue;
            if (a < b && visited[b]) {
                ++pairCount;
            } else if (a == b) {
                ++pairCount;  // a + a = s, и a в V
            }
        }

        if ((pairCount % 2) == 0) {
            visited[s] = true;
        }
    }

    int sizeV = 0;
    for (int i = 0; i < MOD; ++i) {
        if (visited[i]) ++sizeV;
    }

    printf("%d\n", sizeV);
    return 0;
}
