#include <iostream>
#include <vector>
#include <cstdio>

const int MOD = 999983;

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int n;
    long long s;
    std::cin >> n >> s;

    std::vector<bool> v_exists(MOD, false);
    std::vector<int> v_elements;
    v_elements.reserve(n);

    for (int i = 0; i < n; ++i) {
        s = (s * 618023 + 1) % MOD;
        
        int current_s = s;
        int pair_count = 0;

        for (int a : v_elements) {
            int b = current_s - a;
            if (a <= b) {
                if (b >= 0 && b < MOD) {
                    if (v_exists[b]) {
                        pair_count++;
                    }
                }
            }
        }

        if (pair_count % 2 == 0) {
            if (!v_exists[current_s]) {
                v_exists[current_s] = true;
                v_elements.push_back(current_s);
            }
        }
    }

    printf("%zu\n", v_elements.size());

    return 0;
}