def min_offset(c1, c2):
    offsets = [0, 1, 2, 3, -3, -2, -1]
    return offsets[(c2 - c1) % 7]


def can_play(melody):
    curr_dist = 0
    max_neg_dist = 0
    max_pos_dist = 0

    curr_char = ord(melody[0])
    for i in range(1, len(melody)):
        next_char = ord(melody[i])
        dist = min_offset(curr_char, next_char)
        curr_char = next_char

        curr_dist += dist

        if curr_dist < max_neg_dist:
            max_neg_dist = curr_dist
        if curr_dist > max_pos_dist:
            max_pos_dist = curr_dist

    total_range = max_pos_dist - max_neg_dist

    if total_range >= 52:
        return "No"

    first_note = melody[0]
    last_note = melody[-1]

    first_positions = []
    for octave in range(8):
        pos = (ord(first_note) - ord("A")) + octave * 7
        if pos < 52:
            first_positions.append(pos)

    for start_pos in first_positions:
        end_pos = start_pos + curr_dist
        if 0 <= end_pos <= 51:
            end_note = chr((end_pos % 7) + ord("A"))
            if end_note == last_note:
                min_absolute = start_pos + max_neg_dist
                max_absolute = start_pos + max_pos_dist

                if 0 <= min_absolute and max_absolute <= 51:
                    return "Yes"

    return "No"


n = int(input())
for i in range(n):
    print(can_play(input().strip()))
