import java.io.*;

public class Kolatz {
    public static void main(String[] args) throws Exception {
        FastScanner in = new FastScanner(System.in);
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)), true);

        String tLine = in.nextToken();
        if (tLine == null) return;
        int t = Integer.parseInt(tLine);

        for (int round = 0; round < t; round++) {
            String cur = in.nextToken();
            if (cur == null) return;

            boolean firstStep = true;

            while (true) {
                if (cur.equals("1") || cur.equals("0")) break;

                long x = parseLongSafe(cur);

                boolean pressRandom;
                if (firstStep) {
                    if ((x & 1L) == 1L && x <= 1_000_000L) {
                        pressRandom = true;
                    } else {
                        pressRandom = false;
                    }
                } else {
                    if ((x & 1L) == 1L && x < 1000L) {
                        pressRandom = true;
                    } else {
                        pressRandom = false;
                    }
                }

                if (pressRandom) {
                    out.println("random");
                } else {
                    out.println("collatz");
                }
                out.flush();

                String nxt = in.nextToken();
                if (nxt == null) return;
                cur = nxt;
                firstStep = false;
            }

            if (cur.equals("0")) return;
        }
    }

    static long parseLongSafe(String s) {
        if (s.length() > 18) return Long.MAX_VALUE;
        long v = 0L;
        for (int i = 0; i < s.length(); i++) {
            int d = s.charAt(i) - '0';
            v = v * 10L + d;
            if (v < 0) return Long.MAX_VALUE;
        }
        return v;
    }

    static class FastScanner {
        private final InputStream in;
        private final byte[] buf = new byte[1 << 16];
        private int ptr = 0, len = 0;

        FastScanner(InputStream is) { in = is; }

        String nextToken() throws IOException {
            StringBuilder sb = new StringBuilder();
            int c;
            while (true) {
                c = read();
                if (c == -1) return sb.length() == 0 ? null : sb.toString();
                if (c > 32) break;
            }
            while (c > 32) {
                sb.append((char)c);
                c = read();
            }
            return sb.toString();
        }

        private int read() throws IOException {
            if (ptr >= len) {
                len = in.read(buf);
                ptr = 0;
                if (len <= 0) return -1;
            }
            return buf[ptr++];
        }
    }
}
