import java.io.*;

public class Kolatz {
    public static void main(String[] args) throws Exception {
        FastIO io = new FastIO(System.in, System.out);
        int tests = io.nextInt();
        for (int i = 0; i < tests; i++) {
            String currentValue = io.nextToken();
            while (true) {
                if (currentValue.equals("0")) {
                    io.out.flush();
                    return;
                }
                if (currentValue.equals("1")) break;

                boolean isEven = isEvenDecimalString(currentValue);

                if (isEven) {
                    io.println("collatz");
                } else {
                    io.println("random");
                }

                io.flushOutput();
                currentValue = io.nextToken();
            }
        }
        io.out.flush();
    }

    private static boolean isEvenDecimalString(String s) {
        char last = s.charAt(s.length() - 1);
        return last == '0' || last == '2' || last == '4' || last == '6' || last == '8';
    }

    private static class FastIO {
        private final InputStream in;
        public final PrintWriter out;
        private final byte[] buffer = new byte[1 << 16];
        private int bufferSize = 0;
        private int bufferIndex = 0;
        private final StringBuilder tokenBuilder = new StringBuilder();

        FastIO(InputStream is, OutputStream os) {
            in = is;
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        }

        String nextToken() throws IOException {
            tokenBuilder.setLength(0);
            int c;
            while (true) {
                c = read();
                if (c == -1) return "0";
                if (!isSpace(c)) break;
            }
            while (c != -1 && !isSpace(c)) {
                tokenBuilder.append((char) c);
                c = read();
            }
            return tokenBuilder.toString();
        }

        int nextInt() throws IOException {
            return Integer.parseInt(nextToken());
        }

        private boolean isSpace(int c) {
            return c == ' ' || c == '\n' || c == '\r' || c == '\t';
        }

        private int read() throws IOException {
            if (bufferIndex >= bufferSize) {
                bufferSize = in.read(buffer);
                bufferIndex = 0;
                if (bufferSize <= 0) return -1;
            }
            return buffer[bufferIndex++];
        }

        void println(String s) {
            out.println(s);
        }

        void flushOutput() {
            out.flush();
        }
    }
}
