import sys
input = sys.stdin.readline

n = int(input().strip())
raw_rows = []
for _ in range(2 * n - 1):
    raw_rows.append(list(map(int, input().split())))
ops = input().strip()

coords = []
vals = []

for i in range(n):
    cnt = n + i
    q0 = -(n - 1) - i
    r0 = i
    row = raw_rows[i]
    for j in range(cnt):
        coords.append((q0 + j, r0))
        vals.append(row[j])

for i in range(n, 2 * n - 1):
    cnt = 3 * n - 2 - i
    row = raw_rows[i]
    down = i - (n - 1)
    q0 = -(n - 1) + down
    r0 = (n - 1) + down
    for j in range(cnt):
        coords.append((q0 + j, r0))
        vals.append(row[j])

def tr_r(q, r):
    return (-r, q + r)

def tr_l(q, r):
    return (q + r, -q)

def tr_t(q, r):
    return (-q - r, r)

def compose(f, g):
    return lambda q, r: f(*g(q, r))

cur_tr = (lambda q, r: (q, r))

for c in ops:
    if c == 'R':
        cur_tr = compose(tr_r, cur_tr)
    elif c == 'L':
        cur_tr = compose(tr_l, cur_tr)
    else:
        cur_tr = compose(tr_t, cur_tr)

placed = {}
for (q, r), v in zip(coords, vals):
    nq, nr = cur_tr(q, r)
    placed[(nq, nr)] = v

layers = {}
for (q, r), v in placed.items():
    if r not in layers:
        layers[r] = {}
    layers[r][q] = v

sorted_r = sorted(layers.keys())

for r in sorted_r:
    qs = sorted(layers[r].keys())
    row_vals = [layers[r][qq] for qq in qs]
    print(' '.join(map(str, row_vals)))