#include <iostream>
#include <vector>
#include <assert.h>

std::vector<int> s2i(std::string &s)
{
    std::vector<int> res(s.size());
    for (int i = 0; i < s.size(); i++)
        res[i] = s[i] - 'A';
    return res;
}

int mod(int k, int n)
{
    return ( ( k % n ) + n ) % n;
}

const int lim = 52;

int fingers(const std::vector<int> &notes, int prev)
{
    for (int i = 1; i < notes.size(); i++)
    {
        int d = mod(notes[i] - prev, 7);
        if (d > 3)
            d -= 7;
        prev += d;
        if (prev < 0 || prev >= lim)
            return false;
    }
    return true;
}

bool check_notation(const std::vector<int> &notes)
{
    if (notes.size() < 2)
        return true;
    for (int octave = 0; octave < 7; octave++)
    {
        if (fingers(notes, notes[0] + octave * 7) == 0)
            return true;
    }
    return false;
}

int main(void)
{
    int t;
    std::string s;
    std::cin >> t;
    for (int i = 0; i < t; i++)
    {
        std::cin >> s;
        std::vector<int> notes = s2i(s);
        std::cout << (check_notation(notes)? "YES" : "NO") << std::endl;
    }
}