#include <algorithm>
#include <bitset>
#include <cmath>
#include <cstdint>  //int32_max
#include <iostream>
#include <iterator>
#include <limits>
#include <map>
#include <numeric>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <unordered_map>
#include <utility>
#include <vector>

using ll = long long;
using namespace std;

ll mod = 998244353;

void sdvigL(vector<int>& a) {
  int t1 = a[0];
  int t2 = a[1];
  int n = a.size();
  for (int i = 0; i < n - 2; ++i) {
    a[i] = a[i + 2];
  }
  a[n - 2] = t1;
  a[n - 1] = t2;
}

void sdvigR(vector<int>& a) {
  int n = a.size();
  int t1 = a[n - 2];
  int t2 = a[n - 1];
  for (int i = n - 1; i > 1; --i) {
    a[i] = a[i - 2];
  }
  a[0] = t1;
  a[1] = t2;
}

void revT(vector<int>& a) {
  int n = a.size();
  for (int i = 1; i < n / 2; ++i) {
    swap(a[i], a[n - i]);
  }
}

void big_sdvig(vector<vector<int>>& t, int k, int i) {
  int n = t[i].size();
  vector<int> tmp(k);
  for (int j = 0; j < k; ++j) {
    tmp[j] = t[i][j];
  }
  for (int j = 0; j < n - k; ++j) {
    t[i][j] = t[i][j + k];
  }
  for (int j = n - k; j < n; ++j) {
    t[i][j] = tmp[j - n + k];
  }
}
void L_on(vector<vector<int>>& t, int k) {
  int n = t.size();
  for (int i = 1; i < n; ++i) {
    int m = k * i / 2;
    big_sdvig(t, m, i);
  }
}

void trans(vector<vector<int>>& t) {
  for (int i = 0; i < t.size(); ++i) {
    reverse(t[i].begin(), t[i].end());
  }
}

void solve() {
  int n;
  cin >> n;
  int m = 2 * n - 1;
  vector<vector<int>> a(m);

  for (int i = 0; i < m; ++i) {
    // a[i].resize(min(n + i, m - i));
    int k = min(n + i, 3 * n - 2 - i);
    a[i].resize(k);
    for (int j = 0; j < a[i].size(); ++j) {
      cin >> a[i][j];
    }
  }
  int k = 12;
  vector<int> b(k);
  for (int i = 0; i < k; ++i) {
    b[i] = i;
  }
  string s;
  cin >> s;
  for (auto ch : s) {
    if (ch == 'L') {
      sdvigL(b);
    } else if (ch == 'R') {
      sdvigR(b);
    } else if (ch == 'T') {
      revT(b);
    }
  }
  for (int i = 0; i < k; ++i) {
    // std::cout << b[i] << " ";
  }

  vector<vector<int>> t(n);
  t[0].push_back(a[n - 1][n - 1]);
  vector<vector<int>> move{{0, 1}, {1, 1}, {+1, -1}, {0, -1}, {-1, 0}, {-1, 0}};
  for (int i = 0; i < n - 1; ++i) {
    vector<int> xy{i, i};
    int l = n - i - 1;
    // t[l].push_back(a[xy[0]][xy[1]]);
    for (int j = 0; j < 6; ++j) {
      for (int _ = 0; _ < l; ++_) {
        t[l].push_back(a[xy[0]][xy[1]]);
        xy[0] += move[j][0];
        xy[1] += move[j][1];
        // t[l].push_back(a[xy[0]][xy[1]]);
      }
    }
  }
  L_on(t, b[0]);
  /*
  for (int i = 0; i < n; ++i) {
    cout << "level " << i << std::endl;
    for (int j = 0; j < t[i].size(); ++j) {
      cout << t[i][j] << " ";
    }
    cout << endl;
  }*/
  vector<vector<int>> ans(m);

  for (int i = 0; i < m; ++i) {
    int k = min(n + i, 3 * n - 2 - i);
    ans[i].resize(k);
  }
  ans[n - 1][n - 1] = a[n - 1][n - 1];
  for (int i = 0; i < n - 1; ++i) {
    vector<int> xy{i, i};
    int l = n - i - 1;
    int cnt = 0;
    for (int j = 0; j < 6; ++j) {
      for (int _ = 0; _ < l; ++_) {
        // t[l].push_back(a[xy[0]][xy[1]]);
        ans[xy[0]][xy[1]] = t[l][cnt];
        xy[0] += move[j][0];
        xy[1] += move[j][1];
        ++cnt;
      }
    }
  }
  // cout << endl;

  if (b[0] > b[1]) {
    trans(ans);
  }

  for (int i = 0; i < m; ++i) {
    for (int j = 0; j < ans[i].size(); ++j) {
      cout << ans[i][j] << " ";
    }
    cout << endl;
  }
}

int main() {
  std::ios_base::sync_with_stdio(false);
  std::cin.tie(0);
  std::cout.tie(0);
  std::cout.precision(10);
  std::cout.setf(std::ios::fixed);
  int t = 1;
  // std::cin >> t;
  while (t--) {
    solve();
  }
}