#include <bits/stdc++.h>
using namespace std;

int mod_pow2(const string& s, int k){
    int m = 1 << k, r = 0;
    for(char c : s){
        if(c >= '0' && c <= '9') r = (r * 10 + (c - '0')) % m;
    }
    return r;
}

bool is_even(const string& s){
    if(s.empty()) return false;
    char c = s.back();
    return ((c - '0') % 2 == 0);
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin >> t)) return 0;
    for(int _ = 0; _ < t; ++_){
        string x;
        if(!(cin >> x)) return 0;
        while(true){
            if(x == "0") return 0;
            if(x == "1") break;

            if(is_even(x)){
                cout << "collatz" << endl;
                if(!(cin >> x)) return 0;
                continue;
            }

            bool got = false;
            for(int tries = 0; tries < 64; ++tries){
                cout << "random" << endl;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                if(x == "1"){ got = true; break; }
                if(mod_pow2(x, 4) == 0){ got = true; break; }
                if(is_even(x)) break;
            }
            if(x == "1") break;
            if(x == "0") return 0;

            if(!is_even(x)){
                cout << "collatz" << endl;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                if(x == "1") break;
            }
        }
    }
    return 0;
}
