#include <bits/stdc++.h>
using namespace std;

static inline int mod_from_string(const string& s, int M) {
    if (M == 1) return 0;
    long long r = 0;
    for (char c : s) {
        r = (r * 10 + (c - '0')) % M;
    }
    return (int)r;
}

static inline int v2_from_string(const string& s, int max_k = 20) {
    static const bool even_digit[10] = {true,false,true,false,true,false,true,false,true,false};
    if (!even_digit[s.back() - '0']) return 0;
    int v = 1;
    for (int k = 2; k <= max_k; ++k) {
        int M = (1 << k);
        if (mod_from_string(s, M) == 0) v = k;
        else break;
    }
    return v;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if (!(cin >> t)) return 0;

    for (int round = 0; round < t; ++round) {
        string x;
        if (!(cin >> x)) return 0;

        while (true) {
            if (x == "0") return 0;
            if (x == "1") break;

            int v2 = v2_from_string(x, 20);

            if (v2 >= 1) {
                cout << "collatz\n" << flush;
                if (!(cin >> x)) return 0;
                continue;
            }

            bool jumped = false;
            for (int tries = 0; tries < 2; ++tries) {
                cout << "random\n" << flush;
                if (!(cin >> x)) return 0;
                if (x == "0") return 0;
                if (x == "1") { jumped = true; break; }
                int v = v2_from_string(x, 20);
                if (v >= 4) {
                    jumped = true;
                    break;
                }
            }
            if (jumped) continue;

            cout << "collatz\n" << flush;
            if (!(cin >> x)) return 0;
        }
    }
    return 0;
}
