#include <bits/stdc++.h>
using namespace std;

static inline bool is_zero(const string& s){ return s=="0"; }
static inline bool is_one(const string& s){ return s=="1"; }
static inline bool is_even(const string& s){ return ((s.back()-'0')%2)==0; }

static inline unsigned mod_pow2(const string& s, unsigned k){
    unsigned m = 1u<<k, r = 0;
    for(char c: s) r = (r*10u + (unsigned)(c-'0')) % m;
    return r;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin>>t)) return 0;

    for(int _=0;_<t;_++){
        string x;
        if(!(cin>>x)) return 0;

        while(true){
            if(is_one(x)) break;

            if(is_even(x)){
                cout<<"collatz\n"<<flush;
                if(!(cin>>x)) return 0;
                if(is_zero(x)) return 0;
                continue;
            }

            unsigned k, R;
            int len = (int)x.size();
            if(len<=6){ k=6; R=12; }
            else if(len<=9){ k=5; R=8; }
            else { k=4; R=6; }

            bool improved=false;
            for(unsigned i=0;i<R;i++){
                cout<<"random\n"<<flush;
                if(!(cin>>x)) return 0;
                if(is_zero(x)) return 0;
                if(is_one(x)) { improved=true; break; }
                if(is_even(x) || mod_pow2(x,k)==0u){ improved=true; break; }
            }

            if(!improved){
                cout<<"collatz\n"<<flush;
                if(!(cin>>x)) return 0;
                if(is_zero(x)) return 0;
                continue;
            }

            while(!is_one(x) && is_even(x)){
                cout<<"collatz\n"<<flush;
                if(!(cin>>x)) return 0;
                if(is_zero(x)) return 0;
            }
        }
    }
    return 0;
}
