#include <bits/stdc++.h>
using namespace std;

static inline bool is_one(const string& s){ return s=="1"; }
static inline bool is_even(const string& s){ return ((s.back()-'0') & 1) == 0; }
static inline int digits(const string& s){ return (int)s.size(); }

static unsigned v2_cap(const string& s, unsigned cap){
    unsigned M = 1u << cap, rem = 0;
    for(char c: s) rem = (rem * 10u + (unsigned)(c - '0')) % M;
    if(rem == 0) return cap;
    unsigned k = 0;
    while(k < cap && ((rem >> k) & 1u) == 0u) ++k;
    return k;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin >> t)) return 0;

    const long long TOTAL_BUDGET = 30000;
    const double SAFE_AVG = 585.0;
    const int MAX_BLUE_LEN = 5;
    const unsigned ACCEPT_V2 = 9;
    const int MAX_GLOBAL_BLUES = 10;

    long long spent = 0;
    int global_blues_used = 0;

    for(int round = 0; round < t; ++round){
        string x;
        if(!(cin >> x)) return 0;

        bool blue_used_this_round = false;

        while(true){
            if(is_one(x)) break;

            if(is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                spent += digits(x);
                continue;
            }

            double avg_so_far = (round == 0 ? 0.0 : (double)spent / round);
            bool can_try_blue = !blue_used_this_round
                                && global_blues_used < MAX_GLOBAL_BLUES
                                && digits(x) <= MAX_BLUE_LEN
                                && avg_so_far > SAFE_AVG;

            if(can_try_blue){
                cout << "random\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                spent += digits(x);
                blue_used_this_round = true;
                ++global_blues_used;

                if(is_one(x)) continue;

                unsigned v = v2_cap(x, 12);
                if(v >= ACCEPT_V2){
                    while(!is_one(x) && is_even(x)){
                        cout << "collatz\n" << flush;
                        if(!(cin >> x)) return 0;
                        if(x == "0") return 0;
                        spent += digits(x);
                    }
                    continue;
                } else {
                }
            }

            cout << "collatz\n" << flush;
            if(!(cin >> x)) return 0;
            if(x == "0") return 0;
            spent += digits(x);
        }

        if (round + 1 >= t/2) {
            if (global_blues_used < MAX_GLOBAL_BLUES)
                global_blues_used = MAX_GLOBAL_BLUES;
        }

        if (spent > TOTAL_BUDGET) return 0;
    }

    return 0;
}
