#include <bits/stdc++.h>
using namespace std;

static inline bool is_one(const string& s){ return s=="1"; }
static inline bool is_even(const string& s){ return ((s.back()-'0')&1)==0; }

static unsigned v2_cap(const string& s, unsigned cap=16){
    unsigned v = 0, pow2 = 1, rem = 0;
    for(unsigned k=1; k<=cap; ++k){
        pow2 <<= 1;
        rem = 0;
        for(char c: s) rem = (rem*10u + (unsigned)(c-'0')) % pow2;
        if(rem & 1u) return k-1;
    }
    return cap;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin>>t)) return 0;

    for(int _=0;_<t;++_){
        string x;
        if(!(cin>>x)) return 0;

        bool blue_used=false;
        int blue_tries_left=2;

        while(true){
            if(is_one(x)) break;

            if(is_even(x)){
                cout<<"collatz\n"<<flush;
                if(!(cin>>x)) return 0;
                if(x=="0") return 0;
                continue;
            }

            bool should_try_blue = !blue_used && blue_tries_left>0 && (int)x.size()<=6;

            if(should_try_blue){
                cout<<"random\n"<<flush;
                if(!(cin>>x)) return 0;
                if(x=="0") return 0;
                if(is_one(x)) continue;

                unsigned v = v2_cap(x, 12);
                if(v>=5){
                    blue_used=true;
                    while(!is_one(x) && is_even(x)){
                        cout<<"collatz\n"<<flush;
                        if(!(cin>>x)) return 0;
                        if(x=="0") return 0;
                    }
                    continue;
                }else{
                    --blue_tries_left;
                    if(blue_tries_left==0) blue_used=true;
                    cout<<"collatz\n"<<flush;
                    if(!(cin>>x)) return 0;
                    if(x=="0") return 0;
                    continue;
                }
            }else{
                cout<<"collatz\n"<<flush;
                if(!(cin>>x)) return 0;
                if(x=="0") return 0;
            }
        }
    }
    return 0;
}
