#include <iostream>
#include <string>
#include <cmath>

using namespace std;

long long collatz(long long x) {
    if (x % 2 == 0) {
        return x / 2;
    } else {
        return 3 * x + 1;
    }
}

int count_digits(long long x) {
    if (x == 0) return 1;
    return floor(log10(x)) + 1;
}

int main() {
    int t;
    cin >> t;

    for (int i = 0; i < t; i++) {
        long long current;
        cin >> current;

        while (true) {
            if (current == 1) {
                break;
            }

            long long next_collatz = collatz(current);
            int collatz_digits = count_digits(next_collatz);

            if (current <= 1000000) {
                long long random_min = 3 * current + 1;
                long long random_max = 6 * current;

                bool use_random = false;

                for (long long candidate = random_min; candidate <= random_max; candidate++) {
                    long long test = candidate;
                    int steps = 0;
                    int total_cost = 0;

                    while (test > 1 && steps < 10) {
                        test = collatz(test);
                        total_cost += count_digits(test);
                        steps++;

                        if (total_cost > collatz_digits * 2) {
                            break;
                        }
                    }

                    if (total_cost < collatz_digits * 2 && steps > 0) {
                        use_random = true;
                        break;
                    }
                }

                if (use_random) {
                    cout << "random" << endl;
                } else {
                    cout << "collatz" << endl;
                }
            } else {
                if (current % 2 == 0) {
                    cout << "collatz" << endl;
                } else {
                    long long after_collatz = collatz(current);
                    long long after_double_collatz = collatz(after_collatz);

                    if (after_double_collatz < current / 2) {
                        cout << "collatz" << endl;
                    } else {
                        cout << "random" << endl;
                    }
                }
            }

            cout.flush();
            cin >> current;

            if (current == 0) {
                return 0;
            }
            if (current == 1) {
                break;
            }
        }
    }

    return 0;
}