#pragma GCC optimize("O3")
#pragma GCC optimize("unroll-loops")
#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <climits>
#include <cmath>

using namespace std;

const int MOD = 1'000'000'007;
const int MAX_P = 1000001;
const int MAX_N = 2 * MAX_P + 2;
vector<long long> fact(MAX_N);
vector<long long> inv_fact(MAX_N);
vector<long long> pow4(MAX_N);


long long mod_pow(long long a, long long b) {
    long long res = 1;
    a %= MOD;
    while (b) {
        if (b & 1) res = res * a % MOD;
        a = a * a % MOD;
        b >>= 1;
    }
    return res;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i < MAX_N; i++) {
        fact[i] = (fact[i - 1] * i) % MOD;
    }

    inv_fact[MAX_N - 1] = mod_pow(fact[MAX_N - 1], MOD - 2);
    for (int i = MAX_N - 2; i >= 0; i--) {
        inv_fact[i] = (inv_fact[i + 1] * (i + 1)) % MOD;
    }

    pow4[0] = 1;
    for (int i = 1; i < MAX_P; i++) {
        pow4[i] = (pow4[i - 1] * 4) % MOD;
    }
}

long long solve(long long p, long long m) {
    long long t1 = (2LL * p + m + 1) % MOD;
    long long t2 = pow4[p];
    long long t3 = (fact[p] * fact[p]) % MOD;
    long long inv = inv_fact[2 * p + 1];
    long long ans = (t1 * t2) % MOD;
    
    ans = (ans * t3) % MOD;
    ans = (ans * inv) % MOD;
    return ans;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    precompute();
    int t;
    cin >> t;
    while (t--) {
        long long p, m;
        cin >> p >> m;
        cout << solve(p, m) << endl;
    }
    return 0;
}