﻿#include <iostream>
#include <vector>
using namespace std;

const int MOD = 1000000007;

long long mod_pow(long long base, long long exp, long long mod) {
    long long result = 1;
    while (exp > 0) {
        if (exp & 1) result = result * base % mod;
        base = base * base % mod;
        exp >>= 1;
    }
    return result;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    for (int i = 0; i < T; ++i) {
        int p, t;
        cin >> p >> t;

        long long term = 1;
        long long sum = 1;

        for (int k = 0; k < p; ++k) {
            term = term * 2 % MOD;
            term = term * (p - k) % MOD;
            term = term * mod_pow(2LL * p - k, MOD - 2, MOD) % MOD;
            sum = (sum + term) % MOD;
        }

        long long numerator = (2LL * p + t + 1) % MOD;
        long long denominator_inv = mod_pow(2LL * p + 1, MOD - 2, MOD);
        long long ans = sum * numerator % MOD * denominator_inv % MOD;

        cout << ans << '\n';
    }

    return 0;
}