﻿#include <iostream>
#include <vector>
#include <cstdint>
#include <limits>

struct Point {
    long long x, y;
};

int main() {
    std::ios::sync_with_stdio(false);
    int n;
    std::cin >> n;
    std::vector<Point> p(n);
    for (int i = 0; i < n; ++i) std::cin >> p[i].x >> p[i].y;
    long long best_d2 = -1, a = 0, b = 1;
    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            long long dx = p[j].x - p[i].x;
            long long dy = p[j].y - p[i].y;
            long long d2 = dx * dx + dy * dy;
            if (d2 > best_d2) {
                best_d2 = d2;
                a = dx; b = dy;
            }
        }
    }
    long long smin = LLONG_MAX;
    long long smax = LLONG_MIN;
    for (const auto& q : p) {
        long long s = a * q.x + b * q.y;
        if (s < smin) smin = s;
        if (s > smax) smax = s;
    }
    long long c1 = -smin;
    long long c2 = -smax;
    std::cout << a << ' ' << b << ' ' << c1 << std::endl;
    std::cout << a << ' ' << b << ' ' << c2;
    return 0;
}