#include <iostream>
#include <algorithm>
#include <vector>
#include <numbers>
#include <set>
#include <map>
// #include <unordered_set>
// #include <unordered_map>
#include <cmath>
#include <iomanip>

using namespace std;

using ll = long long;
using ld = long double;
using ull = unsigned long long;

const ll inf = 1e18;

struct Point {
    int x;
    int y;
};

std::istream& operator>>(std::istream& in, Point& p) {
    in >> p.x >> p.y;
    return in;
}

using Vector = Point;

ll scalar(Vector& lhs, Vector& rhs) {
    return lhs.x * rhs.x + lhs.y * rhs.y;
}

ld length(Vector& vec) {
    return sqrt(scalar(vec, vec));
}

signed main() {
  Point p1, p2, p3, p4;
  std::cin >> p1 >> p2 >> p3 >> p4;  
  Vector v1{p2.x - p1.x, p2.y - p1.y};
  Vector v2{p3.x - p2.x, p3.y - p2.y};
  ld width = length(v1);
  ld height = length(v2);
  std::cout << std::fixed << std::setprecision(8) << (3.14159265358979323846 * width * height) / 4;
}