import sys

input = sys.stdin.readline

# Все 52 белые клавиши с буквами A-G, повторяющимися (октава 7 раз + 3)
white_keys = "ABCDEFG" * 7 + "ABC"  # длина 52

# Для каждой буквы идет список индексов, где она встречается на клавиатуре
positions = {c: [] for c in "ABCDEFG"}
for i, c in enumerate(white_keys):
    positions[c].append(i)

t = int(input())
result = []

for _ in range(t):
    melody = input().strip()

    # Для первой ноты подходит любая клавиша из positions[melody[0]]
    prev_positions = set(positions[melody[0]])

    can_play = True

    for note in melody[1:]:
        current_pos = positions[note]
        # Выбираем такие позиции для текущей ноты, которые отличаются не больше, чем на 3 от любой позиции прошлой ноты
        next_positions = set()
        for pos in current_pos:
            # Проверяем есть ли pos близко к какой-то позиции из prev_positions (расстояние не более 3)
            if any(abs(pos - pp) <= 3 for pp in prev_positions):
                next_positions.add(pos)

        if not next_positions:
            can_play = False
            break
        prev_positions = next_positions

    result.append("Yes" if can_play else "No")

print("\n".join(result))