#include <algorithm>
#include <chrono>
#include <complex>
#include <iostream>
#include <numeric>
#include <random>
#include <ranges>
#include <set>
#include <cmath>
#include <map>
#include <unordered_map>
#include <vector>

#define ELAPSED_TIME (std::chrono::duration_cast<chrono::milliseconds>(std::chrono::steady_clock::now() - start_time).count())


using ll = long long;


// constexpr ll ROOT_FACTOR = 1;

using namespace std;
ll INF = 1e12;

ll coll(ll x, ll niter) {
    ll iter = 0;
    for (ll i = 0; i < niter; ++i) {
        if (x == 1) return iter;
        if (x % 2 == 0) {
            x /= 2;
        } else {
            if (x > INF) return niter;
            x = 3 * x + 1;
        }
        ++iter;
    }
    return iter;
}

unordered_map<ll, bool> cash;

constexpr ll mod = 1e9 + 7;

ll fpow(ll a, ll b, ll m) {
    ll res = 1 % m;
    for (; b > 0; b >>= 1) {
        if (b & 1)
            res = (res * a) % m;
        a = (a * a) % m;
    }
    return res;
}

ll frac(ll a, ll b, ll m) {
    a %= m, b %= m;
    if (a < 0) a += m;
    if (a % b)
        return (a + m * frac(-a, m, b)) / b;
    return a / b;
}

int main() {
    int t;
    cin >> t;
    for (int _ = 0; _ < t; ++_) {
        int p, m;
        cin >> p >> m;

        cout << (m + 1) * (1 + frac(p * p, 2 * m + p, mod)) << "\n";


    }
}

/*




3
4 1 8
3 5 1 7
2 1 6 1 8
1 7 1 9
8 9 9
TL

TR




 */
