#include <algorithm>
#include <chrono>
#include <complex>
#include <iostream>
#include <numeric>
#include <random>
#include <ranges>
#include <set>
#include <cmath>
#include <map>
#include <unordered_map>
#include <vector>

#define ELAPSED_TIME (std::chrono::duration_cast<chrono::milliseconds>(std::chrono::steady_clock::now() - start_time).count())


using ll = long long;


// constexpr ll ROOT_FACTOR = 1;

using namespace std;
ll INF = 1e12;

ll coll(ll x, ll niter) {
    ll iter = 0;
    for (ll i = 0; i < niter; ++i) {
        if (x == 1) return iter;
        if (x % 2 == 0) {
            x /= 2;
        }
        else {
            if (x > INF) return niter;
            x = 3 * x + 1;
        }
        ++iter;
    }
    return iter;
}

unordered_map<ll, bool> cash;

int main() {
    int t;
    cin >> t;
    for (int _ = 0; _ < t; ++_) {
        ll x;
        bool using_collaz = false;
        while (true) {
            cin >> x;
            if (x == 0) return 0;
            if (x == 1) break;
            ll maxiter = 8 * static_cast<ll>(log2(x)) + 1;
            if (using_collaz) {
                cout << "collatz" << endl;
            }
            else if (x % 2 == 1) {
                bool flag;
                if (cash.find(x) != cash.end()) {
                    flag = cash[x];
                }
                else {
                    flag = coll(x, maxiter + 1) >= maxiter;
                    cash[x] = flag;
                }
                if (flag) {
                    cout << "random" << endl;
                }
                else {
                    using_collaz = true;
                    cout << "collatz" << endl;
                }
            }
            else {
                cout << "collatz" << endl;
            }
        }
    }
}

/*




3
4 1 8
3 5 1 7
2 1 6 1 8
1 7 1 9
8 9 9
TL

TR




 */
