#include <algorithm>
#include <chrono>
#include <complex>
#include <iostream>
#include <numeric>
#include <random>
#include <ranges>
#include <set>
#include <cmath>
#include <vector>

#define ELAPSED_TIME (std::chrono::duration_cast<chrono::milliseconds>(std::chrono::steady_clock::now() - start_time).count())


using ll = long long;

constexpr ll INF = 1e17;

// constexpr ll ROOT_FACTOR = 1;

using namespace std;

void print(int n, const vector<vector<int>> &v) {
    for (int i = 0; i < 2 * n - 1; ++i) {
        for (int j = 0; j < n - min(i, 2 * n - 2 - i); ++j) {
            cout << " ";
        }
        for (int j: v[i]) {
            cout << j << " ";
        }
        cout << "\n";
    }
}

ll fpow(ll a, ll b, ll m) {
    ll res = 1 % m;
    for (; b > 0; b >>= 1) {
        if (b & 1)
            res = (res * a) % m;
        a = (a * a) % m;
    }
    return res;
}

int main() {
    int n;
    cin >> n;
    vector<int> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }
    vector<int> res;
    res.reserve(n);
    for (int i = n - 1; i >= 0; --i) {
        res.insert(res.begin() + a[i], i);
    }
    for (int i = 0; i < n; ++i) {
        cout << res[n - i - 1] + 1 << " ";
    }
    cout << endl;
}


/*




3
4 1 8
3 5 1 7
2 1 6 1 8
1 7 1 9
8 9 9
TL

TR




 */
