#include <bits/stdc++.h>
using namespace std;

#define ll long long

ll collatz(ll x) {
	if (x % 2 == 0)
		return x / 2;
	else 
		return 3 * x + 1;
}

ll get_sum(ll x) {
	ll sum = 0;
	while (x) {
		sum++;
		x /= 10;
	}
	return sum;
}

const ll MAXX = 70000000;
const ll AV = 1500;

int ams[MAXX + 1];
ll sums[MAXX + 1];

ll calc(ll n) {
	if (n > MAXX)
		return AV;
	if (ams[n] != AV)
		return ams[n];
	
	if (n % 2 == 0) {
		return ams[n] = get_sum(n) + calc(n / 2);
	} else {
		return ams[n] = get_sum(n) + calc(n * 3 + 1);
	}
}


void the_tactic(ll x) {
	if (x * 6 < MAXX) {
		if ((sums[x * 6] - sums[x * 3] + x * 6 - x * 3 - 1) / (x * 6 - x * 3) < ams[collatz(x)]) {
			cout << "random" << endl;
			return;
		}
	}
	cout << "collatz" << endl;
}

signed main() {
	for (ll i = 0; i < MAXX; i++) {
		ams[i] = AV;
	}
	ams[1] = 0;
	for (ll i = 2; i < MAXX; i++) {
		calc(i);
	}
	sums[0] = 0;
	for (ll i = 1; i < MAXX; i++) {
		sums[i] = sums[i - 1] + ams[i];
	}

	ll t; cin >> t;
	while (t--) {
		string x; cin >> x;
		while (x != "1") {
			if (x.length() > 8) {
				cout << "collatz" << endl;
			} else {
				the_tactic(stoll(x));
			}

			cin >> x;
			if (x == "0") {
				cout << "meow :(";
				return 0;
			}
		}
	}
}