#include <algorithm>
#include <bitset>
#include <chrono>
#include <climits>
#include <cmath>
#include <fstream>
#include <functional>
#include <iostream>
#include <list>
#include <map>
#include <numeric>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <complex>

using namespace std;

template<class T>
ostream &operator<<(ostream &out, const vector<T> &a) {
    for (auto &i: a) out << i << " ";
    return out;
}

template<class T>
T read() {
    T t;
    cin >> t;
    return t;
}

template<class T>
void operator>>(istream &in, vector<T> &a) { for (auto &i: a) in >> i; }

template<class T>
void operator>>(istream &in, vector<vector<T>> &a) { for (auto &i: a) in >> i; }

#define ll long long
#define ull unsigned ll
#define ld long double
#define M_PI 3.14159265358979323846
#define all(x) x.begin(), x.end()
#define rall(x) x.rbegin(), x.rend()
#define X first
#define Y second
#define int ll

constexpr ll MOD = 999983;
constexpr ll GOIDA = 4096;
using cd = complex<double>;
const double PI = acos(-1);

void fft(vector<cd> & a, bool invert) {
    int n = a.size();
    if (n == 1) {
        return;
    }

    vector<cd> a0(n / 2), a1(n / 2);
    for (int i = 0; 2 * i < n; i++) {
        a0[i] = a[2*i];
        a1[i] = a[2*i+1];
    }

    fft(a0, invert);
    fft(a1, invert);

    double ang = 2 * PI / n * (invert ? -1 : 1);
    cd w(1), wn(cos(ang), sin(ang));
    for (int i = 0; 2 * i < n; i++) {
        a[i] = a0[i] + w * a1[i];
        a[i + n/2] = a0[i] - w * a1[i];
        if (invert) {
            a[i] /= 2;
            a[i + n/2] /= 2;
        }

        w *= wn;
    }
}

vector<int> convolution(const vector<int>& a, const vector<int>& b) {
    int n = 1;
    while (n < a.size() + b.size() - 1) {
        n <<= 1;
    }

    vector<cd> fa(n);
    for (auto&& i : a) {
        cd((double)i, 0);
    }

    vector<cd> fb(n);
    for (auto&& i : b) {
        cd((double)i, 0);
    }

    fft(fa, false);
    fft(fb, false);
    for (int i = 0; i < n; ++i) {
        fa[i] *= fb[i];
    }

    fft(fa, true);
    vector<int> res(a.size() + b.size() - 1);
    for (int i = 0; i < res.size(); ++i) {
        int ans = llround(fa[i].real());
        res[i] = ans & 3;
    }

    return res;
}

int calc1(int s, vector<int>& buf, vector<int>& conv, vector<uint8_t>& p2, unordered_set<int>& buf_s) {
    int ans = 0;
    if (!conv.empty()) {
        if (s >= 0 && s < conv.size()) {
            ans += conv[s];
        }
    }

    for (auto&& v : buf) {
        int y = s - v;
        if (y >= 0 && y < MOD && p2[y]) {
            ans += 2;
        }
    }

    for (auto&& v : buf) {
        int y = s - v;
        if (y >= 0 && y < MOD && buf_s.find(y) != buf_s.end()) {
            ans += 1;
        }
    }

    return ans & 3;
}

int calc2(int s, vector<uint8_t>& p1) {
    if (s % 2) {
        return 0;
    }

    int a = s / 2;
    if (0 <= a && a < MOD && p1[a]) {
        return 1;
    }

    return 0;
}

void rebuild(vector<uint8_t>& p1, vector<uint8_t>& p2, vector<int>& buf, unordered_set<int>& buf_s, vector<int>& conv) {
    for (auto&& x : buf) {
        p2[x] = 1;
    }

    buf.clear();
    buf_s.clear();

    vector<int> a(MOD);
    for (int i = 0; i < MOD; ++i) {
        a[i] = p2[i] ? 1 : 0;
    }

    conv = convolution(a, a);
};

void solution() {
    int n = read<int>();
    int s = read<int>();
    vector<uint8_t> p1(MOD, 0);
    vector<uint8_t> p2(MOD, 0);
    vector<int> buf;
    unordered_set<int> buf_s;
    vector<int> conv;

    int ans = 0;
    for (int i = 0; i < n; ++i) {
        s = (s * 618023 + 1) % 999983;
        int t1 = calc1(s, buf, conv, p2, buf_s);
        int t2 = calc2(s, p1);
        int tmp = (t1 + t2) & 3;
        bool flag = tmp == 0;
        if (flag) {
            if (!p1[s]) {
                p1[s] = 1;
                ++ans;
                buf.push_back(s);
                buf_s.insert(s);
                if (buf.size() > GOIDA) {
                    rebuild(p1, p2, buf, buf_s, conv);
                }
            }
        }
    }

    cout << ans << '\n';
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
//    auto ttt = read<int>();
    auto ttt = 1;
    while (ttt--) solution();
}