#include <vector>
#include <iostream>

using namespace std;

struct row {
    row() = default;

    row(vector<int> v) : _row(std::move(v)) {}

    int &operator[](int i) {
        if (rev) return _row[_row.size() - 1 - i];
        return _row[i];
    }

    const int &operator[](int i) const {
        if (rev) return _row[_row.size() - 1 - i];
        return _row[i];
    }

    int size() const {
        return (int) _row.size();
    }

    void reverse_dir() {
        rev = !rev;
    }

private:
    vector<int> _row;
    bool rev = false;
};

struct Gex {
    Gex(int n) : _rows(init(n)) {}

    int rows() const {
        return (int) _rows.size();
    }

    int n() const {
        return (rows() + 1) / 2;
    }

    row &operator[](int i) {
        return _rows[i];
    }

    const row &operator[](int i) const {
        return _rows[i];
    }

    void lt() {
        left_turns = (left_turns + 1) % 6;
    }

    void rt() {
        left_turns = (left_turns + 5) % 6;
    }

    void t() {
        reverse_before = !reverse_before;
        left_turns = (12 - left_turns) % 6;
    }

    void print() {
        apply_all();
        for (int i = 0; i < rows(); i++) {
            for (int j = 0; j < _rows[i].size(); j++) {
                cout << _rows[i][j] << " ";
            }
            cout << "\n";
        }
    }

private:
    vector<row> _rows;
    int left_turns = 0;
    bool reverse_before = false;

    static vector<row> init(int n) {
        vector<row> rs;
        rs.reserve(2 * n - 1);
        for (int i = 0; i < n; i++) rs.emplace_back(vector<int>(n + i));
        for (int i = n - 2; i >= 0; i--) rs.emplace_back(vector<int>(n + i));
        return rs;
    }

    static pair<int, int> source_after_single_left_turn(int total_rows, const vector<int> &sizes, int i, int j) {
        if (i < total_rows / 2 + 1) {
            int sz = sizes[i];
            if (j < sz - i) {
                return {j, sizes[j] - 1 - i};
            }

            return {j, total_rows - 1 - i};
        }

        int gs = (total_rows + 1) / 2;
        int t = i - total_rows / 2;
        if (j < gs - t - 1) {
            return {j + t, j};
        }

        return {j + t, gs - 1 - t};
    }

    static vector<row> rotate_left_once(const vector<row> &g) {
        int rws = g.size();
        int gs = (rws + 1) / 2;
        vector<row> ng = init(gs);

        vector<int> sizes(rws);
        for (int i = 0; i < rws; i++) {
            sizes[i] = g[i].size();
        }

        for (int i = 0; i < rws; i++) {
            for (int j = 0; j < ng[i].size(); j++) {
                auto p = source_after_single_left_turn(rws, sizes, i, j);
                ng[i][j] = g[p.first][p.second];
            }
        }

        return ng;
    }

    void apply_all() {
        bool reverse_after = false;
        int k = left_turns % 6;
        if (k < 0) k += 6;

        if (k > 3) {
            reverse_before = !reverse_before;
            k = (6 - k) % 6;
            reverse_after = true;
        }

        if (reverse_before) {
            for (int i = 0; i < rows(); i++) {
                _rows[i].reverse_dir();
            }
        }

        while (k--) {
            _rows = rotate_left_once(_rows);
        }

        if (reverse_after) {
            for (int i = 0; i < rows(); i++) {
                _rows[i].reverse_dir();
            }
        }
    }
};

Gex read(int n) {
    Gex g(n);
    for (int i = 0; i < g.rows(); i++) {
        for (int j = 0; j < g[i].size(); j++) {
            int x;
            cin >> x;
            g[i][j] = x;
        }
    }

    return g;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    Gex g = read(n);
    char c;
    while (cin >> c) {
        if (c == 'L') {
            g.lt();
        } else if (c == 'R') {
            g.rt();
        } else if (c == 'T') {
            g.t();
        }
    }

    g.print();
    return 0;
}