#include <bits/stdc++.h>
#include <utility>
using namespace std;

#define int long long

#define double long double


double pi = std::acos(-1);

double zzzz = sqrtl(3) / (double)2;

void solve() {
    int n;
    cin >> n;
    vector<vector<int>> hex_in;
    for (int i = 0; i < n; ++i) {
        std::vector<int> line(n + i);
        for (auto& x: line) cin >> x;
        hex_in.push_back(std::move(line));
    }
    for (int i = 1; i < n; ++i) {
        std::vector<int> line(2 * n - 1 - i);
        for (auto& x: line) cin >> x;
        hex_in.push_back(std::move(line));
    }

    auto to_polar = [&](int i, int j) {
        int y = 2 * (n - 1 - i);
        int x = 2 * j + abs(y) / 2 - 2 * (n - 1);
        double yy = y * zzzz;
        double r = yy * yy + x * x;
        double degree = atan2l(yy, x);
        return  std::make_pair(r, degree);
    };

    auto to_orth = [&](double r, double degree) {
        r = sqrtl(r);
        int x = round(r * cos(degree));
        int y = round(r * sin(degree) / zzzz);
        assert(y % 2 == 0);
        assert((x - y/2) % 2 == 0);
        int i = n - 1 - y / 2;
        int j = (x - abs(y)/2) / 2 + n - 1;
        return std::make_pair(i, j);
    };
 
    auto get_to = [&](int from_i, int from_j, double rot, bool mirror) {
        auto [r, degree] = to_polar(from_i, from_j);
        if (mirror) {
            degree = -(degree - pi/2) + pi/2;
        }
        
        degree += rot;
        auto [i, j] = to_orth(r, degree);
        return std::make_pair(i, j);
    };
    string s;
    cin >> s;
    int int_rot = 0;
    bool mirror = false;
    for (auto c: s) {
        if (c == 'L') {
            ++int_rot;
        } else if (c == 'R') {
            --int_rot;
        } else if (c == 'T') {
            int_rot *= -1;
            mirror = !mirror;
        } else {
            assert(false);
        }
    }

    double rot = (double)int_rot * (pi / 3);

    vector<vector<int>> res = hex_in;
    for (int i = 0; i < (int)hex_in.size(); ++i) {
        for (int j = 0; j < (int)hex_in[i].size(); ++j) {
            auto [toi, toj] = get_to(i, j, rot, mirror);
            res[toi][toj] = hex_in[i][j];
        }
    }

    for (auto& v: res) {
        for (auto& rl: v) {
            std::cout << rl << ' ';
        }std::cout << endl;
    }


}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    
    int nt = 1;
    // cin >> nt;
    while (nt--) {
        solve();
    }
}
