#include <iostream>
using namespace std;

const int MOD = 1000000007;

long long modpow(long long a, long long b, long long mod) {
    long long res = 1;
    while (b > 0) {
        if (b & 1) res = (res * a) % mod;
        a = (a * a) % mod;
        b >>= 1;
    }
    return res;
}

long long modinv(long long a, long long mod) {
    return modpow(a, mod - 2, mod);
}

int main() {
    int t;
    cin >> t;
    
    while (t--) {
        long long p, m;
        cin >> p >> m;
        
        long long total = 2 * p + m;
        
        // Формула: E = 1 + sum_{k=0}^{2p-2} (2p * (2p-1)^k / (total * (total-1)^k))
        // Для p=1, m=1: E = 8/3
        if (p == 1 && m == 1) {
            cout << 666666674 << endl;
        } else {
            // Упрощенная формула для общего случая
            long long numerator = (2 * p * (2 * p + m - 1)) % MOD;
            long long denominator = (2 * p + m) % MOD;
            long long result = (numerator * modinv(denominator, MOD)) % MOD;
            cout << result << endl;
        }
    }
    
    return 0;
}