    #include <iostream>
#include <string>
#include <vector>
#include <set>
using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int t;
    cin >> t;
    string notes = "ABCDEFG";
    
    while (t--) {
        string melody;
        cin >> melody;
        
        set<int> current_positions;
        // Первая нота - любая из 8 возможных позиций
        for (int octave = 0; octave < 8; octave++) {
            current_positions.insert(octave * 7);
        }
        
        bool possible = true;
        
        for (char note : melody) {
            int note_index = notes.find(note);
            set<int> next_positions;
            
            for (int pos : current_positions) {
                for (int octave = 0; octave < 8; octave++) {
                    int new_pos = octave * 7 + note_index;
                    if (abs(new_pos - pos) <= 3) {
                        next_positions.insert(new_pos);
                    }
                }
            }
            
            if (next_positions.empty()) {
                possible = false;
                break;
            }
            current_positions = next_positions;
        }
        
        cout << (possible ? "Yes" : "No") << endl;
    }
    
    return 0;
}