#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>
using namespace std;

int main() {
    int n;
    cin >> n;
    vector<long long> lengths(n);
    for (int i = 0; i < n; i++) {
        cin >> lengths[i];
    }
    
    long long total_sum = 0;
    for (long long len : lengths) total_sum += len;
    
    long long min_area = LLONG_MAX, max_area = 0;
    
    // Используем битовые маски для перебора
    for (int mask = 1; mask < (1 << n) - 1; mask++) {
        long long sum1 = 0;
        for (int i = 0; i < n; i++) {
            if (mask & (1 << i)) {
                sum1 += lengths[i];
            }
        }
        long long sum2 = total_sum - sum1;
        long long area = sum1 * sum2;
        
        if (area > 0) {
            min_area = min(min_area, area);
            max_area = max(max_area, area);
        }
    }
    
    cout << min_area << " " << max_area << endl;
    return 0;
}