#include <bits/stdc++.h>
using namespace std;

const int MOD = 1000000007;
const int MAX_P = 1000000;

long long fact[2 * MAX_P + 1], inv_fact[2 * MAX_P + 1];
long long comb[MAX_P + 1];
long long pow4[MAX_P + 1];

long long mod_pow(long long a, long long e) {
  long long r = 1;
  while (e) {
    if (e & 1) r = r * a % MOD;
    a = a * a % MOD;
    e >>= 1;
  }
  return r;
}

void precompute() {
  fact[0] = 1;
  for (int i = 1; i <= 2 * MAX_P; i++) {
    fact[i] = fact[i - 1] * i % MOD;
  }

  inv_fact[2 * MAX_P] = mod_pow(fact[2 * MAX_P], MOD - 2);
  for (int i = 2 * MAX_P - 1; i >= 0; i--) {
    inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
  }

  for (int p = 0; p <= MAX_P; p++) {
    if (p == 0) {
      comb[p] = 1;
    } else {
      comb[p] = fact[2 * p] * inv_fact[p] % MOD * inv_fact[p] % MOD;
    }
  }

  pow4[0] = 1;
  for (int p = 1; p <= MAX_P; p++) {
    pow4[p] = pow4[p - 1] * 4 % MOD;
  }
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(0);

  precompute();

  int t;
  cin >> t;

  while (t--) {
    int p, m;
    cin >> p >> m;

    long long num = (2LL * p + m + 1) % MOD * pow4[p] % MOD;
    long long den = (2LL * p + 1) % MOD * comb[p] % MOD;
    long long ans = num * mod_pow(den, MOD - 2) % MOD;

    cout << ans << "\n";
  }

  return 0;
}