#include <bits/stdc++.h>

using namespace std;

bool playable(const string& sequence) {
    int n = sequence.size();

    if (n == 1) {
        return true;
    }
    
    vector<bool> current(52, false);

    int firstNote = sequence[0] - 'A';
    for (int octave = 0; octave < 8; octave++) {
        int pos = firstNote + octave * 7;
        if (pos < 52) {
            current[pos] = true;
        }   
    }
    
    for (int i = 1; i < n; i++) {
        vector<bool> next(52, false);
        int targetNote = sequence[i] - 'A';

        for (int prevPos = 0; prevPos < 52; prevPos++) {
            if (!current[prevPos]) continue;

            for (int octave = 0; octave < 8; octave++) {
                int currPos = targetNote + octave * 7;
                if (currPos >= 52) continue;

                if (abs(prevPos - currPos) <= 3) {
                    next[currPos] = true;
                }
            }
        }
        current = next;

        bool hasPossible = false;
        for (bool possible : current) {
            if (possible) {
                hasPossible = true;
                break;
            }
        }
        if (!hasPossible) {
            return false;
        }
    }
    
    return true;
}

int main() {
    
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    
    int t;
    cin >> t;
    
    for (int i = 0; i < t; i++) {
        string sequence;
        cin >> sequence;
        
        if (playable(sequence)) {
            cout << "Yes" << endl;
        } else {
            cout << "No" << endl;
        }
    }
    
    return 0;
}