#include <iostream>
#include <vector>
#include <algorithm>
#include <iomanip>
#include <numeric>

#define all(x) x.begin(), x.end()

using namespace std;

using ll = long long int;
using ld = long double;

ll p, m, N;
const ll mod = 1e9 + 7;
vector<ll> fact(2e6 + 1000);

ll binpowmod(ll a, ll b, ll m) {
    a %= m;
    ll res = 1;
    while (b > 0) {
        if (b & 1) res = (res * a) % m;
        a = (a * a) % m;
        b >>= 1;
    }
    return (res % mod);
}

ll Inv(ll a) {
    return binpowmod(a, mod - 2, mod);
}

void init() {
    fact[0] = 1;
    for (ll i = 1; i < fact.size(); i++) {
        fact[i] = (fact[i - 1] * i) % mod;
    }
}

ll C(ll n, ll k) {
    if (k > n || k < 0) return 0;
    return (((fact[n] * Inv(fact[k])) % mod) * Inv(fact[n - k])) % mod;
}

int main() {
    init();
    ll tt; cin >> tt;
    while (tt--) {
        cin >> p >> m; N = 2 * p + m;
        ll r = (N + 1) * binpowmod(2, 2 * p, mod);
        r %= mod;
        ll q = Inv((2 * p + 1) * C(2 * p, p));
        q %= mod;
        cout << (r * q) % mod << '\n';
    }
}
