#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;
const int MAX = 2e6 + 5;

int fact[MAX], invfact[MAX];

int modpow(int a, int e) {
    int res = 1;
    while (e) {
        if (e & 1) res = 1LL * res * a % MOD;
        a = 1LL * a * a % MOD;
        e >>= 1;
    }
    return res;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i < MAX; i++) {
        fact[i] = 1LL * fact[i-1] * i % MOD;
    }
    invfact[MAX-1] = modpow(fact[MAX-1], MOD-2);
    for (int i = MAX-2; i >= 0; i--) {
        invfact[i] = 1LL * invfact[i+1] * (i+1) % MOD;
    }
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    
    precompute();
    
    int t;
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        int n = 2*p + m;
        
        int num = 1LL * (n + 1) * modpow(2, 2*p) % MOD;
        num = 1LL * num * fact[p] % MOD;
        num = 1LL * num * fact[p] % MOD;
        int den = fact[2*p + 1];
        
        int ans = 1LL * num * modpow(den, MOD-2) % MOD;
        cout << ans << '\n';
    }
    
    return 0;
}
