﻿#include <iostream>
#include <cmath>
#include <algorithm>
#include <vector>
#include <numbers>

struct Point
{
    int x, y;
};

double distance(Point a, Point b)
{
    return std::sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}

double rectangle_area(std::vector<Point>& rect)
{
    double width = distance(rect[0], rect[1]);
    double height = distance(rect[1], rect[2]);
    return width * height;
}

int main()
{
    std::vector<Point> rect(4);
    for (int i = 0; i < 4; i++)
        std::cin >> rect[i].x >> rect[i].y;

    double width = distance(rect[0], rect[1]);
    double height = distance(rect[1], rect[2]);

    double a = width / 2.0;
    double b = height / 2.0;

    double area = std::numbers::pi * a * b;

    std::cout << area << std::endl;

    return 0;
}