#include <bits/stdc++.h>
using namespace std;
using cd = complex<double>;
const double PI = acos(-1.0);

void fft(vector<cd> & a, bool invert) {
    int n = (int)a.size();
    static vector<int> rev;
    static vector<cd> roots{cd(0,0), cd(1,0)};
    if ((int)rev.size() != n) {
        int k = __builtin_ctz(n);
        rev.assign(n,0);
        for (int i = 0; i < n; ++i)
            rev[i] = (rev[i>>1] >> 1) | ((i&1) << (k-1));
    }
    for (int i = 0; i < n; ++i)
        if (i < rev[i]) swap(a[i], a[rev[i]]);
    if ((int)roots.size() < n) {
        int k = __builtin_ctz(roots.size());
        roots.resize(n);
        while ((1<<k) < n) {
            double angle = 2 * PI / (1<<(k+1));
            for (int i = 1 << (k-1); i < (1<<k); ++i) {
                roots[2*i] = roots[i];
                double ang = angle * (2*i+1 - (1<<k));
                roots[2*i+1] = cd(cos(ang), sin(ang));
            }
            ++k;
        }
    }
    for (int len = 1; len < n; len <<= 1) {
        for (int i = 0; i < n; i += 2*len) {
            for (int j = 0; j < len; ++j) {
                cd u = a[i+j];
                cd v = a[i+j+len] * roots[len + j];
                a[i+j] = u + v;
                a[i+j+len] = u - v;
            }
        }
    }
    if (invert) {
        reverse(a.begin() + 1, a.end());
        for (int i = 0; i < n; ++i) a[i] /= n;
    }
}

vector<long long> convolution(const vector<int>& A, const vector<int>& B) {
    int n = (int)A.size(), m = (int)B.size();
    if (!n || !m) return {};
    int sz = 1;
    while (sz < n + m - 1) sz <<= 1;
    vector<cd> fa(sz);
    for (int i = 0; i < n; ++i) fa[i] = cd(A[i], 0);
    for (int i = 0; i < m; ++i) fa[i] += cd(0, B[i]);
    fft(fa, false);
    vector<cd> fb(sz);
    for (int i = 0; i < sz; ++i) {
        int j = (sz - i) & (sz - 1);
        cd a1 = (fa[i] + conj(fa[j])) * cd(0.5, 0);
        cd a2 = (fa[i] - conj(fa[j])) * cd(0, -0.5);
        fb[i] = a1 * a1 + a2 * a2 * cd(0,1);
    }
    fft(fb, true);
    vector<long long> res(n + m - 1);
    for (int i = 0; i < (int)res.size(); ++i)
        res[i] = (long long)(fb[i].real() + 0.5);
    return res;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, s0;
    if (!(cin >> n >> s0)) return 0;
    const int M = 999983, A = 618023;
    vector<int> seq(n);
    long long s = s0;
    for (int i = 0; i < n; ++i) {
        s = (s * A + 1) % M;
        seq[i] = (int)s;
    }
    int B = min(n, 2000);
    vector<char> inBase(M, 0);
    vector<int> baseList; baseList.reserve(M);
    vector<long long> Ubase(M, 0);
    for (int blockStart = 0; blockStart < n; blockStart += B) {
        int blockEnd = min(n, blockStart + B);
        vector<int> baseArr(M);
        for (int x : baseList) baseArr[x] = 1;
        vector<long long> conv = convolution(baseArr, baseArr);
        for (int i = 0; i < M; ++i) {
            long long g = conv[i];
            if (i + M < (int)conv.size()) g += conv[i + M];
            conv[i] = g;
        }
        long long inv2 = (M + 1) / 2;
        for (int i = 0; i < M; ++i) {
            int a = (int)((1LL * i * inv2) % M);
            long long H = (inBase[a] ? 1LL : 0LL);
            long long g = conv[i];
            long long U = (g - H) / 2;
            Ubase[i] = U;
        }
        vector<int> newList;
        newList.reserve(B);
        for (int idx = blockStart; idx < blockEnd; ++idx) {
            int cur = seq[idx];
            long long U = Ubase[cur];
            for (int y : newList) {
                int need = cur - y;
                if (need < 0) need += M;
                if (inBase[need]) U++;
            }
            int sz = (int)newList.size();
            for (int i = 0; i < sz; ++i)
                for (int j = i; j < sz; ++j) {
                    int a = newList[i], b = newList[j];
                    int sum = a + b;
                    if (sum >= M) sum -= M;
                    if (sum == cur) U++;
                }
            if ((U % 2) == 0)
                newList.push_back(cur);
        }
        for (int x : newList)
            if (!inBase[x]) {
                inBase[x] = 1;
                baseList.push_back(x);
            }
    }
    cout << (int)baseList.size() << "\n";
}