#include <iostream>
#include <vector>
#include <string>
#include <sstream>
#include <algorithm>

using namespace std;

// Функция для чтения гекса
vector<vector<int>> get_gex(int n) {
    vector<vector<int>> gex;
    for (int i = 0; i < 2 * n - 1; i++) {
        string line;
        getline(cin, line);
        stringstream ss(line);
        vector<int> row;
        int num;
        while (ss >> num) {
            row.push_back(num);
        }
        gex.push_back(row);
    }
    return gex;
}

// Функция поворота влево на 60 градусов
vector<vector<int>> rotate_to_l(vector<vector<int>> gex, int n) {
    int size = gex.size();
    vector<vector<int>> result;
    int n1 = n - 1;
    int n2 = 2 * n - 2;
    
    for (int i = 0; i < size; i++) {
        int row_len = gex[i].size();
        vector<int> new_row;
        int col_start = max(0, n1 - i);
        int row_start = max(0, i - n1);
        int max_col = n2 - i;
        
        for (int j = 0; j < row_len; j++) {
            int row = row_start + j;
            int col = col_start + j;
            if (col > max_col) col = max_col;
            new_row.push_back(gex[row][col]);
        }
        result.push_back(new_row);
    }
    return result;
}

// Функция поворота вправо на 60 градусов
vector<vector<int>> rotate_to_r(vector<vector<int>> gex, int n) {
    int size = gex.size();
    vector<vector<int>> result;
    int n1 = n - 1;
    int n2 = 2 * n - 2;
    
    for (int i = 0; i < size; i++) {
        int row_len = gex[i].size();
        vector<int> new_row;
        int col_start = max(0, i - n1);
        int row_start = max(0, n1 - i);
        int max_row = n2 - i;
        
        for (int j = 0; j < row_len; j++) {
            int row = row_start + j;
            int col = col_start + j;
            if (row > max_row) row = max_row;
            new_row.push_back(gex[row][col]);
        }
        result.push_back(new_row);
    }
    return result;
}

// Функция для вывода гекса
void print_gex(vector<vector<int>> gex, int n) {
    for (int i = 0; i < 2 * n - 1; i++) {
        int spaces = abs(n - i - 1);
        if (spaces > 0) {
            cout << string(spaces, ' ');
        }
        for (size_t j = 0; j < gex[i].size(); j++) {
            if (j > 0) cout << " ";
            cout << gex[i][j];
        }
        cout << endl;
    }
}

// Функция для оптимизации строки команд
string optimize_commands(string commands) {
    string result = commands;
    // Удаляем LR и RL
    size_t pos;
    while ((pos = result.find("LR")) != string::npos) {
        result.replace(pos, 2, "");
    }
    while ((pos = result.find("RL")) != string::npos) {
        result.replace(pos, 2, "");
    }
    // Удаляем TT
    while ((pos = result.find("TT")) != string::npos) {
        result.replace(pos, 2, "");
    }
    // Заменяем TRT на L
    while ((pos = result.find("TRT")) != string::npos) {
        result.replace(pos, 3, "L");
    }
    // Заменяем TLT на R
    while ((pos = result.find("TLT")) != string::npos) {
        result.replace(pos, 3, "R");
    }
    return result;
}

int main() {
    int n;
    cin >> n;
    cin.ignore(); // Игнорируем символ новой строки после n
    
    vector<vector<int>> gex = get_gex(n);
    
    string commands;
    getline(cin, commands);
    
    // Оптимизируем команды
    commands = optimize_commands(commands);
    
    // Разбиваем команды по 'T'
    vector<string> parts;
    stringstream ss(commands);
    string part;
    while (getline(ss, part, 'T')) {
        parts.push_back(part);
    }
    
    int count_reverse = parts.size() - 1;
    
    // Обрабатываем каждую часть
    for (size_t i = 0; i < parts.size(); i++) {
        string part = parts[i];
        int count_L = count(part.begin(), part.end(), 'L');
        int count_R = count(part.begin(), part.end(), 'R');
        
        // Вычисляем net_rotations
        int net_rotations = (count_R - count_L) % 6;
        if (net_rotations < 0) net_rotations += 6;
        
        // Выполняем повороты в оптимальном направлении
        if (net_rotations <= 3) {
            for (int j = 0; j < net_rotations; j++) {
                gex = rotate_to_r(gex, n);
            }
        } else {
            for (int j = 0; j < 6 - net_rotations; j++) {
                gex = rotate_to_l(gex, n);
            }
        }
        
        // Выполняем отражение если нужно
        if (count_reverse > 0) {
            for (auto& row : gex) {
                reverse(row.begin(), row.end());
            }
            count_reverse--;
        }
    }
    
    print_gex(gex, n);
    
    return 0;
}