#include <iostream>
#include <vector>
#include <cmath>
#include <limits>

using namespace std;

int main() {
    int n;
    cin >> n;
    vector<pair<int, int>> points(n);
    for (int i = 0; i < n; i++) {
        cin >> points[i].first >> points[i].second;
    }

    double best_dist = -1;
    int best_a = 0, best_b = 0;
    int best_c_min = 0, best_c_max = 0;

    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            int a = points[j].first - points[i].first;
            int b = points[j].second - points[i].second;
            
            int min_val = a * points[0].first + b * points[0].second;
            int max_val = min_val;
            
            for (const auto& p : points) {
                int val = a * p.first + b * p.second;
                if (val < min_val) min_val = val;
                if (val > max_val) max_val = val;
            }
            
            double dist_val = (max_val - min_val) / sqrt(a * a + b * b);
            
            if (dist_val > best_dist) {
                best_dist = dist_val;
                best_a = a;
                best_b = b;
                best_c_min = -min_val;
                best_c_max = -max_val;
            }
        }
    }

    cout << best_a << " " << best_b << " " << best_c_min << endl;
    cout << best_a << " " << best_b << " " << best_c_max << endl;

    return 0;
}
