#include <iostream>
#include <algorithm>
#include <cmath>
#include <vector>
using namespace std;

const int MOD = 1e9 + 7;

long long mod_pow(long long a, long long b, int mod){
    long long r = 1;
    while (b) {
        if (b & 1) r = r * a % mod;
        a = a * a % mod;
        b >>= 1;
    }
    return r;
}

/*
long long fac(int n){
    if (n==1) return 1;
    return n * fac(n-1);
}

long long binom(int n, int r) {
    if (r < 0 || r > n) return 0;
    if (r > n - r) r = n - r;
    
    long long res = 1;
    for (int i = 1; i <= r; ++i) {
        res = res * (n - r + i) / i;
    }
    return res;
}
*/

int main(){
    int z;
    cin >> z;
    while (z--){
        int p, m;
        cin >> p >> m;
        int n = 2 * p + m;

        vector<long long> fact(n + 1), inv_fact(n + 1);
        fact[0] = 1;
        for (int i = 1; i <= n; i++) {
            fact[i] = fact[i - 1] * i % MOD;
        }

        inv_fact[n] = mod_pow(fact[n], MOD - 2, MOD);
        for (int i = n - 1; i >= 0; i--) {
            inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
        }

        auto binom = [&](int n, int k) -> long long {
            if (k < 0 || k > n) return 0;
            return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD;
        };

        long long E = 1;

        vector<long long> pow2(p + 1);
        pow2[0] = 1;
        for (int i = 1; i <= p; i++) {
            pow2[i] = pow2[i - 1] * 2 % MOD;
        }

        for (int k = 1; k < n; ++k){
            long long chisl = 0;
            long long znam = 1;
            
            for (int t = max(0, (k - m)); t <= min(p, k); ++t){
                long long to = binom(p, t) * binom(m, k - t) % MOD;
                // chisl +=(binom(p, t) * binom(m, (k - t)) * (1LL << t) * fac(k));
                to = to * pow2[t] % MOD;
                to = to * fact[k] % MOD;
                chisl = (chisl + to) % MOD;
            }
            
            for(int i = 0; i < k; ++i){
                znam = znam * (n - i) % MOD;
            }
            
            long long inv_znam = mod_pow(znam, MOD - 2, MOD);
            
            E = (E + chisl * inv_znam) % MOD;
        }

        cout << E << endl;

    }
    return 0;
}