#include <iostream>
#include <vector>
using namespace std;

const int MOD = 1000000007;
const int MAX_N = 2000000 + 10;

vector<long long> fact(MAX_N);
vector<long long> inv_fact(MAX_N);
vector<long long> pow4(1000000 + 10);

long long power(long long a, long long b) {
    long long res = 1;
    while (b) {
        if (b & 1) res = res * a % MOD;
        a = a * a % MOD;
        b >>= 1;
    }
    return res;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i < MAX_N; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }
    inv_fact[MAX_N - 1] = power(fact[MAX_N - 1], MOD - 2);
    for (int i = MAX_N - 2; i >= 0; i--) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    }
    pow4[0] = 1;
    for (int i = 1; i <= 1000000; i++) {
        pow4[i] = pow4[i - 1] * 4 % MOD;
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    precompute();
    int t;
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        long long num = (2LL * p + m + 1) % MOD;
        num = num * pow4[p] % MOD;
        num = num * fact[p] % MOD;
        num = num * fact[p] % MOD;
        long long den = fact[2 * p + 1];
        long long ans = num * inv_fact[2 * p + 1] % MOD;
        cout << ans << endl;
    }
    return 0;
}