#include <iostream>
#include <set>
#include <bitset>

using namespace std;

const int MOD = 999983;
const int MAX = 1000000;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    long long s;
    cin >> n >> s;

    set<int> V;
    bitset<MAX> exists;

    for (int i = 0; i < n; i++) {
        s = (s * 618023 + 1) % MOD;

        int count = 0;
        int limit = s / 2;
        for (auto a : V) {
            if (a > limit) break;
            if (exists[s - a]) {
                count++;
            }
        }

        if (count % 2 == 0) {
            if (!exists[s]) {
                exists[s] = true;
                V.insert(s);
            }
        }
    }

    cout << V.size() << endl;

    return 0;
}