#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

struct Point {
    int x, y;
    Point() {}
    Point(int x, int y) : x(x), y(y) {}
    Point operator - (const Point& other) const {
        return Point(x - other.x, y - other.y);
    }
};

int cross(Point a, Point b) {
    return a.x * b.y - a.y * b.x;
}

long long distance2(Point a, Point b) {
    return (long long)(a.x - b.x) * (a.x - b.x) + (long long)(a.y - b.y) * (a.y - b.y);
}

int main() {
    int n;
    cin >> n;
    vector<Point> points(n);
    for (int i = 0; i < n; i++) {
        cin >> points[i].x >> points[i].y;
    }

    if (n == 2) {
        Point A = points[0];
        Point B = points[1];
        int dx = B.x - A.x;
        int dy = B.y - A.y;
        cout << dx << " " << dy << " " << -dx * A.x - dy * A.y << endl;
        cout << dx << " " << dy << " " << -dx * B.x - dy * B.y << endl;
        return 0;
    }

    Point p0 = points[0];
    int idx0 = 0;
    for (int i = 1; i < n; i++) {
        if (points[i].y < p0.y || (points[i].y == p0.y && points[i].x < p0.x)) {
            p0 = points[i];
            idx0 = i;
        }
    }

    vector<Point> rest;
    for (int i = 0; i < n; i++) {
        if (i != idx0) rest.push_back(points[i]);
    }

    sort(rest.begin(), rest.end(), [&](Point a, Point b) {
        Point va = a - p0;
        Point vb = b - p0;
        int cr = cross(va, vb);
        if (cr != 0) return cr > 0;
        return distance2(a, p0) < distance2(b, p0);
        });

    vector<Point> hull;
    hull.push_back(p0);
    for (Point p : rest) {
        while (hull.size() >= 2) {
            Point a = hull[hull.size() - 2];
            Point b = hull.back();
            Point c = p;
            if (cross(b - a, c - a) <= 0) {
                hull.pop_back();
            }
            else break;
        }
        hull.push_back(p);
    }

    long long maxDist2 = 0;
    Point A, B;
    int m = hull.size();
    for (int i = 0; i < m; i++) {
        for (int j = i + 1; j < m; j++) {
            long long d2 = distance2(hull[i], hull[j]);
            if (d2 > maxDist2) {
                maxDist2 = d2;
                A = hull[i];
                B = hull[j];
            }
        }
    }

    int dx = B.x - A.x;
    int dy = B.y - A.y;
    cout << dx << " " << dy << " " << -dx * A.x - dy * A.y << endl;
    cout << dx << " " << dy << " " << -dx * B.x - dy * B.y << endl;

    return 0;
}