#include <iostream>
#include <vector>
#include <climits>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    if (!(cin >> n)) return 0;

    vector<long long> a(n);
    long long total = 0;
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
        total += a[i];
    }

    long long minArea = LLONG_MAX;
    long long maxArea = 0;

    int all = 1 << n;
    for (int mask = 1; mask < all - 1; ++mask) {
        long long sum = 0;
        for (int i = 0; i < n; ++i)
            if (mask & (1 << i))
                sum += a[i];

        long long other = total - sum;
        long long area = sum * other;

        if (area > 0) {
            if (area < minArea) minArea = area;
            if (area > maxArea) maxArea = area;
        }
    }

    cout << minArea << " " << maxArea << endl;
    return 0;
}
